(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4687,        140]*)
(*NotebookOutlinePosition[      5352,        163]*)
(*  CellTagsIndexPosition[      5308,        159]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(f[x_, y_] = 1 - \((y^2 + x)\)/\((1 + x^2)\)\)], "Input"],

Cell[BoxData[
    \(surfgraf = Plot3D[f[x, y], {x, \(-2\), 2}, {y, \(-2\), 2}]\ ; 
    graf1[a_] := 
      ParametricPlot3D[{a, y, f[a, y]}, {y, \(-2\), 2}, 
          DisplayFunction \[Rule] Identity] /. \ 
        Line[x_] \[Rule] {RGBColor[0, 1, 0], Thickness[ .007], Line[x]}; 
    graf2[b_] := 
      ParametricPlot3D[{x, b, f[x, b]}, {x, \(-2\), 2}, 
          DisplayFunction \[Rule] Identity] /. \ 
        Line[x_] \[Rule] {RGBColor[1, 0, 0], Thickness[ .007], 
            Line[x]}\)], "Input"],

Cell[BoxData[
    \(<< Graphics`PlotField3D`\)], "Input"],

Cell[BoxData[
    \(\(vectores[a_, b_] := 
        ListPlotVectorField3D[{{{a, b, f[a, b]}, {1, 0, 
                  D[f[x, y], x] /. {x \[Rule] a, y \[Rule] b}}}, {{a, b, 
                  f[a, b]}, {0, 1, 
                  D[f[x, y], y] /. {x \[Rule] a, y \[Rule] b}}}}, 
            VectorHeads -> True, \ ScaleFunction -> \(( .8 &)\), 
            ColorFunction -> \((RGBColor[0, 0, 1] &)\), 
            DisplayFunction -> Identity] /. \ 
          Line[x_] -> {Thickness[ .007], \ Line[x]};\)\)], "Input"],

Cell[BoxData[
    \(Show[graf1[\(- .8\)], 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[BoxData[
    \(Show[graf1[\(- .8\)], surfgraf, 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[BoxData[
    \(Show[graf2[\(- .5\)], 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[BoxData[
    \(Show[graf2[\(- .5\)], surfgraf, 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[BoxData[
    \(Show[vectores[\(- .8\), \(- .5\)], graf1[\(- .8\)], graf2[\(- .5\)], 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[BoxData[
    \(Show[graf1[\(- .8\)], graf2[\(- .5\)], surfgraf, 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(planotg[a_, b_] := 
      Plot3D[Evaluate[
          f[a, b] + D[f[s, t], s] \((x - a)\) + \ 
              D[f[s, t], t] \((y - b)\) /. {s \[Rule] a, t \[Rule] b}], \ {x, 
          a -  .5, a +  .5}, {y, b -  .5, b +  .5}, 
        DisplayFunction \[Rule] Identity]; \ 
    todo[a_, b_] := 
      Show[surfgraf, graf1[a], graf2[b], planotg[a, b], vectores[a, b], 
        DisplayFunction \[Rule] $DisplayFunction]; \ 
    todo[\(- .8\), \(- .5\)]\)], "Input"],

Cell[BoxData[
    \(todo[\(-1.2\), \(-1\)]\)], "Input"],

Cell[BoxData[
    \(todo[\(-1\), 0]\)], "Input"],

Cell[BoxData[
    \(todo[0.7, 0]\)], "Input"],

Cell[BoxData[
    \(Show[%, ViewPoint -> {0.123, \ \(-2.080\), \ \(-2.667\)}]\)], "Input"],

Cell[BoxData[
    \(\(Table[todo[\(-1\) + k, 0], {k, 0, 2, 1/5}];\)\)], "Input"],

Cell[BoxData[
    \(Show[%, AspectRatio \[Rule] 1]\)], "Input"],

Cell[BoxData[
    \(Show[todo[\(- .8\), \(- .5\)], AspectRatio \[Rule] Automatic, 
      Shading \[Rule] False]\)], "Input"]
},
FrontEndVersion->"4.2 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 873}},
WindowSize->{1272, 835},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 76, 1, 35, "Input"],
Cell[1833, 54, 504, 10, 119, "Input"],
Cell[2340, 66, 57, 1, 35, "Input"],
Cell[2400, 69, 514, 9, 98, "Input"],
Cell[2917, 80, 103, 2, 35, "Input"],
Cell[3023, 84, 113, 2, 35, "Input"],
Cell[3139, 88, 103, 2, 35, "Input"],
Cell[3245, 92, 113, 2, 35, "Input"],
Cell[3361, 96, 150, 2, 35, "Input"],
Cell[3514, 100, 130, 2, 35, "Input"],
Cell[3647, 104, 26, 0, 35, "Input"],
Cell[3676, 106, 481, 10, 98, "Input"],
Cell[4160, 118, 55, 1, 35, "Input"],
Cell[4218, 121, 48, 1, 35, "Input"],
Cell[4269, 124, 45, 1, 35, "Input"],
Cell[4317, 127, 90, 1, 35, "Input"],
Cell[4410, 130, 80, 1, 35, "Input"],
Cell[4493, 133, 63, 1, 35, "Input"],
Cell[4559, 136, 124, 2, 35, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

